
// Version b0.03

/*
 * This class is used to check results of equations to known results. 
 * If values differ by more then 6 figures they are reported as 
 * incorrect and the result value, tabel value and difference is 
 * displayed. If the case is correct 'GOOD' is displayed together
 * with the result value.
 */
public class HeimUnit {

    // This is the limit used to determine correct results
    private static final double limit = Math.pow(10, -6);

    // Particles to be evaluated
    private static Particle e_minus;
    private static Particle e_zero;
    private static Particle mu;
    private static Particle pi_charge;
    private static Particle pi_zero;
    private static Particle eta;
    private static Particle k_charge;
    private static Particle k_zero;
    private static Particle p;
    private static Particle n;
    private static Particle lambda;
    private static Particle sigma_plus;
    private static Particle sigma_minus;
    private static Particle sigma_zero;
    private static Particle xi_charge;
    private static Particle xi_zero;
    private static Particle omega_charge;
    private static Particle delta_plusplus;
    private static Particle delta_plus;
    private static Particle delta_minus;
    private static Particle delta_zero;

    public static void main(String args[]) {

	try {
	    // NOTE: parameters 'new Particle(k, P, Q, kappa, x)'

	    e_minus = new Particle(1, 1, 1, 0, 1);

	    e_zero = new Particle(1, 1, 1, 0, 0);

	    mu = new Particle(1, 1, 1, 1, 0); // x: 0-1?

	    pi_charge = new Particle(1, 2, 0, 0, 0); // x: 0-2?

	    pi_zero = new Particle(1, 2, 0, 0, 1); // x: 0-2?

	    eta = new Particle(1, 0, 0, 0, 0);

	    k_charge = new Particle(1, 1, 0, 1, 0); // x: 0-1?

	    k_zero = new Particle(1, 1, 0, 1, 1); // x: 0-1?

	    p = new Particle(2, 1, 1, 0, 0); // x: 0-1?

	    n = new Particle(2, 1, 1, 0, 1); // x: 0-1?

	    lambda = new Particle(2, 0, 1, 0, 0);

	    sigma_plus = new Particle(2, 2, 1, 0, 0); // x: 0-2?

	    sigma_minus = new Particle(2, 2, 1, 0, 2); // x: 0-2?

	    sigma_zero = new Particle(2, 2, 1, 0, 1); // x: 0-2?

	    xi_charge = new Particle(2, 1, 1, 1, 1); // x: 0-1?

	    xi_zero = new Particle(2, 1, 1, 1, 0); // x: 0-1?

	    omega_charge = new Particle(2, 0, 3, 0, 0);

	    delta_plusplus = new Particle(2, 3, 3, 0, 0); // x: 0-3?

	    delta_plus = new Particle(2, 3, 3, 0, 1); // x: 0-3?

	    delta_minus = new Particle(2, 3, 3, 0, 3); // x: 0-3?

	    delta_zero = new Particle(2, 3, 3, 0, 2); // x: 0-3?
	    
	}
	catch (Exception e ){ System.out.println("Particle Construction error: " + e); }

	//etaAndTheta_Tests();
	//alpha_Tests();

	//quantumNumber_equationQ_Tests();
	//quantumNumber_equationN_Tests();

	//selfCouplingsFunction_BandH_Tests(); // NOTE: These tests use qx and q from Selected Results and not
	//selfCouplingsFunction_A_Tests();     // the constructed particles as input parameters
	//selfCouplingsFunction_a1_Tests();
	//selfCouplingsFunction_a2_Tests();
	//selfCouplingsFunction_a3_Tests();
	//selfCouplingsFunction_W_Tests();
	//selfCouplingsFunction_phi_Tests();

	oldMassEquation_Tests(); // NOTE: These are the old mass equation tests....
	                         // they use qx and q from Selected Results and not
	                         // the constructed particles as input parameter
	
	particle_Tests(); // New tests using particles as input parameter

    }

    public static void etaAndTheta_Tests() {

	unitCase(Constants.eta, 0.98998964, "Constant eta");

	unitCase(QN.eta(0,1), 0.98998964, "eta(0,1) = eta");	
	unitCase(QN.eta(1,1), 0.98756399, "eta(1,1)");
	unitCase(QN.eta(2,1), 0.98516776, "eta(2,1)");
	unitCase(QN.eta(2,2), 0.84242385, "eta(2,2)");

	unitCase(Constants.theta, 7.93991266, "Constant theta");

	unitCase(QN.theta(0,1), 7.93991266, "theta(0,1) = theta");	
	unitCase(QN.theta(1,1), 7.92534503, "theta(1,1)");
	unitCase(QN.theta(2,1), 7.91095114, "theta(2,1)");
	unitCase(QN.theta(2,2), 7.04779227, "theta(2,2)");

    }

    public static void alpha_Tests() {

	unitCase(Constants.alphaPlus, 0.01832211, "Alpha Plus");
	unitCase(Constants.alphaMinus, 0.00812835, "Alpha Minus");

	unitCase(Constants.altAlphaPlus, 0.01832211, "Alpha Plus Old");
	unitCase(Constants.altAlphaMinus, 0.00812835, "Alpha Minus Old");
    }

    public static void quantumNumber_equationQ_Tests() {

	unitCase(QN.Q1(1), 3, "Q1(1)");
	unitCase(QN.Q2(1), 3, "Q2(1)");
	unitCase(QN.Q3(1), 2, "Q3(1)");
	unitCase(QN.Q4(1), 1, "Q4(1)");

	unitCase(QN.Q1(2), 24, "Q1(2)");
	unitCase(QN.Q2(2), 31, "Q2(2)");
	unitCase(QN.Q3(2), 34, "Q3(2)");
	unitCase(QN.Q4(2), 15, "Q4(2)");

    }

    public static void quantumNumber_equationN_Tests() {

	unitCase(QN.N1(1,1), 0.99688127, "N1(1,1)");
	unitCase(QN.N1(1,0), 1, "N1(1,0)");
	unitCase(QN.N1(2,1), 0.99627809, "N1(2,1)");
	unitCase(QN.N1(2,0), 1, "N1(2,0)");
	unitCase(QN.N1(2,2), 0.95891826, "N1(2,2)");

	unitCase(QN.N2(1,1), 0.67506174, "N2(1,1)");
	unitCase(QN.N2(1,0), 0.66666667, "N2(1,0)");
	unitCase(QN.N2(2,1), 0.67670370, "N2(2,1)");
	unitCase(QN.N2(2,0), 0.66666667, "N2(2,0)");
	unitCase(QN.N2(2,2), 0.79136728, "N2(2,2)");

	unitCase(QN.N3(1,1), 1.95731764, "N3(1,1)");
	unitCase(QN.N3(1,0), 2, "N3(1,0)");
	unitCase(QN.N3(2,1), 2.59881924, "N3(2,1)");
	unitCase(QN.N3(2,0), 2.71828183, "N3(2,0)");
	unitCase(QN.N3(2,2), 2.12190443, "N3(2,2)");

	unitCase(QN.N4(1,1), 4, "N4(1,1)");
	unitCase(QN.N4(1,0), 4, "N4(1,0)");
	unitCase(QN.N4(2,1), 4, "N4(2,1)");
	unitCase(QN.N4(2,0), 2, "N4(2,0)");
	unitCase(QN.N4(2,2), 6, "N4(2,2)");

	unitCase(QN.N5(1,1), 1.15773470, "N5(1,1)");
	unitCase(QN.N5(1,0), 1.15773470, "N5(1,0)");
	unitCase(QN.N5(2,1), 1.73247496, "N5(2,1)");
	unitCase(QN.N5(2,0), 1.15773470, "N5(2,0)");
	unitCase(QN.N5(2,2), 76.73214581, "N5(2,2)");

	unitCase(QN.N6(1,1), 0.00000164, "N6(1,1)");
	unitCase(QN.N6(1,0), 0.00000164, "N6(1,0)");
	unitCase(QN.N6(2,1), 0.02518725, "N6(2,1)");
	unitCase(QN.N6(2,0), -0.10493009, "N6(2,0)");
	unitCase(QN.N6(2,2), 0.15580107, "N6(2,2)");
    }

    public static void selfCouplingsFunction_BandH_Tests() {

	unitCase(SelfCouplingFunction.B(1), 27, "B(1)");
	unitCase(SelfCouplingFunction.B(2), 26, "B(2)");

	unitCase(SelfCouplingFunction.H(1), 9, "H(1)");
	unitCase(SelfCouplingFunction.H(2), 104, "H(2)");
    }

    public static void selfCouplingsFunction_A_Tests() {

	unitCase(SelfCouplingFunction.A(1), 2787.59025432, "A(1)");
	unitCase(SelfCouplingFunction.A(2), 14727.57867072, "A(2)");

	unitCase(SelfCouplingFunction.altA(1), 2787.59025432, "Alt A(1)");
	unitCase(SelfCouplingFunction.altA(2), 14727.57867072, "Alt A(2)");
    }

    public static void selfCouplingsFunction_a1_Tests() {

	unitCase(SelfCouplingFunction.a1(1, 1, 1, 1, 0), 35, "a1 Lepton e_+-");
	unitCase(SelfCouplingFunction.a1(1, 0, 1, 1, 0), 34, "a1 Lepton e_0");
	unitCase(SelfCouplingFunction.a1(1, 1, 1, 1, 1), 1, "a1 Lepton mu");
	unitCase(SelfCouplingFunction.a1(1, 1, 2, 0, 0), 25, "a1 Messon pi_+-");
	unitCase(SelfCouplingFunction.a1(1, 0, 2, 0, 0), 22, "a1 Messon pi_0");
	unitCase(SelfCouplingFunction.a1(1, 0, 0, 0, 0), 28, "a1 Messon eta");
	unitCase(SelfCouplingFunction.a1(1, 1, 1, 0, 1), 16, "a1 Messon K_+-");
	unitCase(SelfCouplingFunction.a1(1, 0, 1, 0, 1), 22, "a1 Messon K_0");
	unitCase(SelfCouplingFunction.a1(2, 1, 1, 1, 0), 0, "a1 Baryon p");
	unitCase(SelfCouplingFunction.a1(2, 0, 1, 1, 0), 0, "a1 Baryon n");
	unitCase(SelfCouplingFunction.a1(2, 0, 0, 1, 0), 13, "a1 Baryon lambda");
	unitCase(SelfCouplingFunction.a1(2, 1, 2, 1, 0), 21, "a1 Baryon sigma_+");
	unitCase(SelfCouplingFunction.a1(2, 1, 2, 1, 0), 21, "a1 Baryon sigma_-");
	unitCase(SelfCouplingFunction.a1(2, 0, 2, 1, 0), 21, "a1 Baryon sigma_0");
	unitCase(SelfCouplingFunction.a1(2, 1, 1, 1, 1), 26, "a1 Baryon xi_-");
	unitCase(SelfCouplingFunction.a1(2, 0, 1, 1, 1), 26, "a1 Baryon xi_0");
	unitCase(SelfCouplingFunction.a1(2, 1, 0, 3, 0), 47, "a1 Baryon omega_-");
	unitCase(SelfCouplingFunction.a1(2, 2, 3, 3, 0), 23, "a1 Baryon delta_++");
	unitCase(SelfCouplingFunction.a1(2, 1, 3, 3, 0), 23, "a1 Baryon delta_+");
	unitCase(SelfCouplingFunction.a1(2, 0, 3, 3, 0), 23, "a1 Baryon delta_0");
	unitCase(SelfCouplingFunction.a1(2, 1, 3, 3, 0), 21, "a1 Baryon delta_-");	
    }

    public static void selfCouplingsFunction_a2_Tests() {

	unitCase(SelfCouplingFunction.a2(1, 1, 1, 1, 0, -1), 11, "a2 Lepton e_+-");
	unitCase(SelfCouplingFunction.a2(1, 0, 1, 1, 0, 0), 28, "a2 Lepton e_0");
	unitCase(SelfCouplingFunction.a2(1, 1, 1, 1, 1, -1), 23, "a2 Lepton mu");
	unitCase(SelfCouplingFunction.a2(1, 1, 2, 0, 0, -1), 0, "a2 Messon pi_+-");
	unitCase(SelfCouplingFunction.a2(1, 0, 2, 0, 0, 0), 2, "a2 Messon pi_0");
	unitCase(SelfCouplingFunction.a2(1, 0, 0, 0, 0, 0), 33, "a2 Messon eta");
	unitCase(SelfCouplingFunction.a2(1, 1, 1, 0, 1, -1), 31, "a2 Messon K_+-");
	unitCase(SelfCouplingFunction.a2(1, 0, 1, 0, 1, 0), 17, "a2 Messon K_0");
	unitCase(SelfCouplingFunction.a2(2, 1, 1, 1, 0, 1), 23, "a2 Baryon p");
	unitCase(SelfCouplingFunction.a2(2, 0, 1, 1, 0, 0), 36, "a2 Baryon n");
	unitCase(SelfCouplingFunction.a2(2, 0, 0, 1, 0, 0), 45, "a2 Baryon lambda");
	unitCase(SelfCouplingFunction.a2(2, 1, 2, 1, 0, 1), 30, "a2 Baryon sigma_+");
	unitCase(SelfCouplingFunction.a2(2, 1, 2, 1, 0, -1), 47, "a2 Baryon sigma_-");
	unitCase(SelfCouplingFunction.a2(2, 0, 2, 1, 0, 0), 46, "a2 Baryon sigma_0");
	unitCase(SelfCouplingFunction.a2(2, 1, 1, 1, 1, -1), 25, "a2 Baryon xi_-");
	unitCase(SelfCouplingFunction.a2(2, 0, 1, 1, 1, 0), 22, "a2 Baryon xi_0");
	unitCase(SelfCouplingFunction.a2(2, 1, 0, 3, 0, -1), 3, "a2 Baryon omega_-");
	unitCase(SelfCouplingFunction.a2(2, 2, 3, 3, 0, 2), 27, "a2 Baryon delta_++");
	unitCase(SelfCouplingFunction.a2(2, 1, 3, 3, 0, 1), 22, "a2 Baryon delta_+");
	unitCase(SelfCouplingFunction.a2(2, 0, 3, 3, 0, 0), 39, "a2 Baryon delta_0");
	unitCase(SelfCouplingFunction.a2(2, 1, 3, 3, 0, -1), 27, "a2 Baryon delta_-");
    }

    public static void selfCouplingsFunction_a3_Tests() {

	unitCase(SelfCouplingFunction.a3(1, 1, 1, 1, 0, -1), 89.96774158, "a3 Lepton e_+-");
	unitCase(SelfCouplingFunction.a3(1, 0, 1, 1, 0, 0), 77.11059862, "a3 Lepton e_0");
	unitCase(SelfCouplingFunction.a3(1, 1, 1, 1, 1, -1), 7.26891022, "a3 Lepton mu");
	unitCase(SelfCouplingFunction.a3(1, 1, 2, 0, 0, -1), 95.62488526, "a3 Messon pi_+-");
	unitCase(SelfCouplingFunction.a3(1, 0, 2, 0, 0, 0), -0.03225806, "a3 Messon pi_0");
	unitCase(SelfCouplingFunction.a3(1, 0, 0, 0, 0, 0), 48.65020426, "a3 Messon eta");
	unitCase(SelfCouplingFunction.a3(1, 1, 1, 0, 1, -1), 7.26891022, "a3 Messon K_+-");
	unitCase(SelfCouplingFunction.a3(1, 0, 1, 0, 1, 0), 98.29474138, "a3 Messon K_0");
	unitCase(SelfCouplingFunction.a3(2, 1, 1, 1, 0, 1), 84.22944059, "a3 Baryon p");
	unitCase(SelfCouplingFunction.a3(2, 0, 1, 1, 0, 0), 101.15000035, "a3 Baryon n");
	unitCase(SelfCouplingFunction.a3(2, 0, 0, 1, 0, 0), -0.033333333, "a3 Baryon lambda");
	unitCase(SelfCouplingFunction.a3(2, 1, 2, 1, 0, 1), 26.15371691, "a3 Baryon sigma_+");
	unitCase(SelfCouplingFunction.a3(2, 1, 2, 1, 0, -1), 94.49556347, "a3 Baryon sigma_-");
	unitCase(SelfCouplingFunction.a3(2, 0, 2, 1, 0, 0), 83.86257747, "a3 Baryon sigma_0");
	unitCase(SelfCouplingFunction.a3(2, 1, 1, 1, 1, -1), 15.61504747, "a3 Baryon xi_-");
	unitCase(SelfCouplingFunction.a3(2, 0, 1, 1, 1, 0), 71.62409771, "a3 Baryon xi_0");
	unitCase(SelfCouplingFunction.a3(2, 1, 0, 3, 0, -1), 69.73881899, "a3 Baryon omega_-");
	unitCase(SelfCouplingFunction.a3(2, 2, 3, 3, 0, 2), 82.92386515, "a3 Baryon delta_++");
	unitCase(SelfCouplingFunction.a3(2, 1, 3, 3, 0, 1), 22.64335811, "a3 Baryon delta_+");
	unitCase(SelfCouplingFunction.a3(2, 0, 3, 3, 0, 0), 93.76289283, "a3 Baryon delta_0");
	unitCase(SelfCouplingFunction.a3(2, 1, 3, 3, 0, -1), 69.73881899, "a3 Baryon delta_-");
    }

    public static void selfCouplingsFunction_W_Tests() {

	unitCase(SelfCouplingFunction.W(1, 1, 1, 1, 0, -1), 38.70294226, "W_N=0 Lepton e_+-");
	unitCase(SelfCouplingFunction.W(1, 0, 1, 1, 0, 0), 38.51308957, "W_N=0 Lepton e_0");
	unitCase(SelfCouplingFunction.W(1, 1, 1, 1, 1, -1), 2830.2632345, "W_N=0 Lepton mu");
	unitCase(SelfCouplingFunction.W(1, 1, 2, 0, 0, -1), 3514.46294316, "W_N=0 Messon pi_+-");
	unitCase(SelfCouplingFunction.W(1, 0, 2, 0, 0, 0), 3419.16217346, "W_N=0 Messon pi_0");
	unitCase(SelfCouplingFunction.W(1, 0, 0, 0, 0, 0), 9905.00599107, "W_N=0 Messon eta");
	unitCase(SelfCouplingFunction.W(1, 1, 1, 0, 1, -1), 8857.95769020, "W_N=0 Messon K_+-");
	unitCase(SelfCouplingFunction.W(1, 0, 1, 0, 1, 0), 9332.35821820, "W_N=0 Messon K_0");
	unitCase(SelfCouplingFunction.W(2, 1, 1, 1, 0, 1), 14792.56308050, "W_N=0 Baryon p");
	unitCase(SelfCouplingFunction.W(2, 0, 1, 1, 0, 0), 14828.61089116, "W_N=0 Baryon n");
	unitCase(SelfCouplingFunction.W(2, 0, 0, 1, 0, 0), 16827.97671482, "W_N=0 Baryon lambda");
	unitCase(SelfCouplingFunction.W(2, 1, 2, 1, 0, 1), 18124.03136129, "W_N=0 Baryon sigma_+");
	unitCase(SelfCouplingFunction.W(2, 1, 2, 1, 0, -1), 18183.30294347, "W_N=0 Baryon sigma_-");
	unitCase(SelfCouplingFunction.W(2, 0, 2, 1, 0, 0), 18179.59733741, "W_N=0 Baryon sigma_0");
	unitCase(SelfCouplingFunction.W(2, 1, 1, 1, 1, -1), 18998.73451193, "W_N=0 Baryon xi_-");
	unitCase(SelfCouplingFunction.W(2, 0, 1, 1, 1, 0), 18990.08927597, "W_N=0 Baryon xi_0");
	unitCase(SelfCouplingFunction.W(2, 1, 0, 3, 0, -1), 23157.61451004, "W_N=0 Baryon omega_-");
	unitCase(SelfCouplingFunction.W(2, 2, 3, 3, 0, 2), 18115.38391620, "W_N=0 Baryon delta_++");
	unitCase(SelfCouplingFunction.W(2, 1, 3, 3, 0, 1), 18467.56082305, "W_N=0 Baryon delta_+");
	unitCase(SelfCouplingFunction.W(2, 0, 3, 3, 0, 0), 18508.94119539, "W_N=0 Baryon delta_0");
	unitCase(SelfCouplingFunction.W(2, 1, 3, 3, 0, -1), 18448.51703290, "W_N=0 Baryon delta_-");

    }

    public static void selfCouplingsFunction_phi_Tests() {

	unitCase(SelfCouplingFunction.phi(1, 1, 0, 0, 1, 1, 0, -1), 0, "phi Lepton e_+-");
	unitCase(SelfCouplingFunction.phi(1, 0, 0, 1, 1, 1, 0, 0), 0, "phi Lepton e_0");
	unitCase(SelfCouplingFunction.phi(1, 1, 11, 6, 1, 1, 1, -1), 2.57120915, "phi Lepton mu");
	unitCase(SelfCouplingFunction.phi(1, 1, 2, 3, 2, 0, 0, -1), -2.32863274, "phi Messon pi_+-");
	unitCase(SelfCouplingFunction.phi(1, 0, 6, 4, 2, 0, 0, 0), -5.12094079, "phi Messon pi_0");
	unitCase(SelfCouplingFunction.phi(1, 0, 17, 14, 0, 0, 0, 0), 5.06612007, "phi Messon eta");
	unitCase(SelfCouplingFunction.phi(1, 1, 30, 28, 1, 0, 1, -1), -40.78574065, "phi Messon K_+-");
	unitCase(SelfCouplingFunction.phi(1, 0, 5, 2, 1, 0, 1, 0), -12.73395842, "phi Messon K_0");
	unitCase(SelfCouplingFunction.phi(2, 1, 0, 0, 1, 1, 0, 1), 9.28034058, "phi Baryon p");
	unitCase(SelfCouplingFunction.phi(2, 0, -2, 17, 1, 1, 0, 0), 11.16885467, "phi Baryon n");
	unitCase(SelfCouplingFunction.phi(2, 0, 0, -11, 0, 1, 0, 0), 0, "phi Baryon lambda");
	unitCase(SelfCouplingFunction.phi(2, 1, -12, 10, 2, 1, 0, 1), -6.00947753, "phi Baryon sigma_+");
	unitCase(SelfCouplingFunction.phi(2, 1, -5, -8, 2, 1, 0, -1), -2.01125294, "phi Baryon sigma_-");
	unitCase(SelfCouplingFunction.phi(2, 0, -14, -2, 2, 1, 0, 0), 11.78154008, "phi Baryon sigma_0");
	unitCase(SelfCouplingFunction.phi(2, 1, -17, 2, 1, 1, 1, -1), 23.44132266, "phi Baryon xi_-");
	unitCase(SelfCouplingFunction.phi(2, 0, -1, 6, 1, 1, 1, 0), 90.44612205, "phi Baryon xi_0");
	unitCase(SelfCouplingFunction.phi(2, 1, -1, -15, 0, 3, 0, -1), -137.03604095, "phi Baryon omega_-");
	unitCase(SelfCouplingFunction.phi(2, 2, 9, 4, 3, 3, 0, 2), -1364.07751672, "phi Baryon delta_++");
	unitCase(SelfCouplingFunction.phi(2, 1, -1, -6, 3, 3, 0, 1), -623.74523006, "phi Baryon delta_+");
	unitCase(SelfCouplingFunction.phi(2, 0, -10, 2, 3, 3, 0, 0), -985.00227539, "phi Baryon delta_0");
	unitCase(SelfCouplingFunction.phi(2, 1, -16, -15, 3, 3, 0, -1), -548.14408156, "phi Baryon delta_-");

    }

    public static void oldMassEquation_Tests() {

	unitCase(MainFunctions.massEquation(1, 1, 0, 0, 0, 0, 1, 1, 0, -1), 0.51100343, 0.51099891844, "Mass Lepton e_-");
	unitCase(MainFunctions.massEquation(1, 0, 0, 0, 0, 1, 1, 1, 0, 0), 0.51617049, 0.51617049, "Mass Lepton e_0");
	unitCase(MainFunctions.massEquation(1, 1, 11, 6, 11, 6, 1, 1, 1, -1), 105.65948493, 105.658389, "Mass Lepton mu");
	unitCase(MainFunctions.massEquation(1, 1, 12, 9, 2, 3, 2, 0, 0, -1), 139.56837088, 139.57018, "Mass Messon pi_+-");
	unitCase(MainFunctions.massEquation(1, 0, 12, 3, 6, 4, 2, 0, 0, 0), 134.96004114, 134.9766, "Mass Messon pi_0");
	unitCase(MainFunctions.massEquation(1, 0, 18, 22, 17, 14, 0, 0, 0, 0), 548.80002432, 547.30, "Mass Messon eta");
	unitCase(MainFunctions.massEquation(1, 1, 17, 26, 30, 28, 1, 0, 1, -1), 493.71425074, 493.677, "Mass Messon K_+-");
	unitCase(MainFunctions.massEquation(1, 0, 18, 5, 5, 2, 1, 0, 1, 0), 497.72299959, 497.672, "Mass Messon K_0");
	unitCase(MainFunctions.massEquation(2, 1, 0, 0, 0, 0, 1, 1, 0, 1), 938.27959246, 938.27231, "Mass Baryon p");
	unitCase(MainFunctions.massEquation(2, 0, 0, 0, -2, 17, 1, 1, 0, 0), 939.57336128, 939.56563, "Mass Baryon n");
	unitCase(MainFunctions.massEquation(2, 0, 1, 3, 0, -11, 0, 1, 0, 0), 1115.59979064, 1115.683, "Mass Baryon lambda");
	unitCase(MainFunctions.massEquation(2, 1, 2, -7, -12, 10, 2, 1, 0, 1), 1189.37409717, 1189.37, "Mass Baryon sigma_+");
	unitCase(MainFunctions.massEquation(2, 1, 2, -6, -5, -8, 2, 1, 0, -1), 1197.30443002, 1197.449, "Mass Baryon sigma_-");
	unitCase(MainFunctions.massEquation(2, 0, 2, -7, -14, -2, 2, 1, 0, 0), 1192.47794854, 1192.642, "Mass Baryon sigma_0");
	unitCase(MainFunctions.massEquation(2, 1, 2, 7, -17, 2, 1, 1, 1, -1), 1321.29326013, 1321.32, "Mass Baryon xi_-");
	unitCase(MainFunctions.massEquation(2, 0, 2, 6, -1, 6, 1, 1, 1, 0), 1314.90206200, 1314.9, "Mass Baryon xi_0");
	unitCase(MainFunctions.massEquation(2, 1, 4, 4, -1, -15, 0, 3, 0, -1), 1672.17518902, 1672.45, "Mass Baryon omega_-");
	unitCase(MainFunctions.massEquation(2, 2, 2, 1, 9, 4, 3, 3, 0, 2), 1232.91663788, 1232, "Mass Baryon delta_++");
	unitCase(MainFunctions.massEquation(2, 1, 2, -1, -1, -6, 3, 3, 0, 1), 1234.60981181, 1232, "Mass Baryon delta_+");
	unitCase(MainFunctions.massEquation(2, 0, 2, -1, -10, 2, 3, 3, 0, 0), 1229.99529979, 1232, "Mass Baryon delta_0");
	unitCase(MainFunctions.massEquation(2, 1, 2, -1, -16, -15, 3, 3, 0, -1), 1237.06132359, 1232, "Mass Baryon delta_-");
    }

    public static void particle_Tests() {

	/*unitCase(e_minus.C, 0, "C " + e_minus + " e-");
	unitCase(e_minus.qx, -1, "qx " + e_minus + " e-");
	unitCase(e_minus.q, 1, "q " + e_minus + " e-");
	unitCase(MainFunctions.massEquation(e_minus, 0, 0, 0, 0), 0.51100343, 0.51099891844, "Mass Lepton e_-");

	unitCase(e_zero.C, 0, "C " + e_zero + " e0");
	unitCase(e_zero.qx, 0, "qx " + e_zero + " e0");
	unitCase(e_zero.q, 0, "q " + e_zero + " e0");
	unitCase(MainFunctions.massEquation(e_zero, 0, 0, 0, 1), 0.51617049, 0.51617049, "Mass Lepton e_0");

	unitCase(mu.C, 0, "C " + mu + " mu");
	unitCase(mu.qx, -1, "qx " + mu + " mu");
	unitCase(mu.q, 1, "q " + mu + " mu");
	unitCase(MainFunctions.massEquation(mu, 11, 6, 11, 6), 105.65948493, 105.658389, "Mass Lepton mu");*/

	unitCase(pi_charge.C, 0, "C " + pi_charge + " pi+-");
	unitCase(pi_charge.qx, 1, "qx " + pi_charge + " pi+-");
	unitCase(pi_charge.q, 1, "q " + pi_charge + " pi+-");	
	unitCase(MainFunctions.massEquation(pi_charge, 12, 9, 2, 3), 139.56837088, 139.57018, "Mass Messon pi_+-");

	unitCase(pi_zero.C, 0, "C " + pi_zero + " pi0");
	unitCase(pi_zero.qx, 0, "qx " + pi_zero + " pi0");
	unitCase(pi_zero.q, 0, "q " + pi_zero + " pi0");
	unitCase(MainFunctions.massEquation(pi_zero, 12, 3, 6, 4), 134.96004114, 134.9766, "Mass Messon pi_0");

	unitCase(eta.C, 0, "C " + eta + " eta");
	unitCase(eta.qx, 0, "qx " + eta + " eta");	
	unitCase(eta.q, 0, "q " + eta + " eta");
	unitCase(MainFunctions.massEquation(eta, 18, 22, 17, 14), 548.80002432, 547.30, "Mass Messon eta");

	/*unitCase(k_charge.C, 1, "C " + k_charge + " K+-");
	unitCase(k_charge.qx, 1, "qx " + k_charge + " K+-");
	unitCase(k_charge.q, 1, "q " + k_charge + " K+-");
	unitCase(MainFunctions.massEquation(k_charge, 17, 26, 30, 28), 493.71425074, 493.677, "Mass Messon K_+-");	

	unitCase(k_zero.C, 1, "C " + k_zero + " K0");
	unitCase(k_zero.qx, 0, "qx " + k_zero + " K0");
	unitCase(k_zero.q, 0, "q " + k_zero + " K0");
	unitCase(MainFunctions.massEquation(k_zero, 18, 5, 5, 2), 497.72299959, 497.672, "Mass Messon K_0");
	
	unitCase(p.C, 0, "C " + p + " p");
	unitCase(p.qx, 1, "qx " + p + " p");
	unitCase(p.q, 1, "q " + p + " p");
	unitCase(MainFunctions.massEquation(p, 0, 0, 0, 0), 938.27959246, 938.27231, "Mass Baryon p");*/
	
	/*unitCase(n.C, 0, "C " + n + " n");
	unitCase(n.qx, 0, "qx " + n + " n");
	unitCase(n.q, 0, "q " + n + " n");	
	unitCase(MainFunctions.massEquation(n, 0, 0, -2, 17), 939.57336128, 939.56563, "Mass Baryon n");
	
	unitCase(lambda.C, -1, "C " + lambda + " lambda");
	unitCase(lambda.qx, 0, "qx " + lambda + " lambda");
	unitCase(lambda.q, 0, "q " + lambda + " lambda");
	unitCase(MainFunctions.massEquation(lambda, 1, 3, 0, -11), 1115.59979064, 1115.683, "Mass Baryon lambda");
	
	unitCase(sigma_plus.C, -1, "C " + sigma_plus + " sigma+");
	unitCase(sigma_plus.qx, 1, "qx " + sigma_plus + " sigma+");
	unitCase(sigma_plus.q, 1, "q " + sigma_plus + " sigma+");
	unitCase(MainFunctions.massEquation(sigma_plus, 2, -7, -12, 10), 1189.37409717, 1189.37, "Mass Baryon sigma_+");
	
	/*unitCase(sigma_minus.C, -1, "C " + sigma_minus + " sigma-");
	unitCase(sigma_minus.qx, -1, "qx " + sigma_minus + " sigma-");
	unitCase(sigma_minus.q, 1, "q " + sigma_minus + " sigma-");
	unitCase(MainFunctions.massEquation(sigma_minus, 2, -6, -5, -8), 1197.30443002, 1197.449, "Mass Baryon sigma_-");
	
	unitCase(sigma_zero.C, -1, "C " + sigma_zero + " sigma0");
	unitCase(sigma_zero.qx, 0, "qx " + sigma_zero + " sigma0");
	unitCase(sigma_zero.q, 0, "q " + sigma_zero + " sigma0");
	unitCase(MainFunctions.massEquation(sigma_zero, 2, -7, -14, -2), 1192.47794854, 1192.642, "Mass Baryon sigma_0");
	
	unitCase(xi_charge.C, -2, "C " + xi_charge + " xi+-");
	unitCase(xi_charge.qx, -1, "qx " + xi_charge + " xi+-");
	unitCase(xi_charge.q, 1, "q " + xi_charge + " xi+-");
	unitCase(MainFunctions.massEquation(xi_charge, 2, 7, -17, 2), 1321.29326013, 1321.32, "Mass Baryon xi_-");
	
	unitCase(xi_zero.C, -2, "C " + xi_zero + " xi0");
	unitCase(xi_zero.qx, 0, "qx " + xi_zero + " xi0");
	unitCase(xi_zero.q, 0, "q " + xi_zero + " xi0");
	unitCase(MainFunctions.massEquation(xi_zero, 2, 6, -1, 6), 1314.90206200, 1314.9, "Mass Baryon xi_0");
	
	unitCase(omega_charge.C, -3, "C " + omega_charge + " omega+-");
	unitCase(omega_charge.qx, -1, "qx " + omega_charge + " omega+-");
	unitCase(omega_charge.q, 1, "q " + omega_charge + " omega+-");
	unitCase(MainFunctions.massEquation(omega_charge, 4, 4, -1, -15), 1672.17518902, 1672.45, "Mass Baryon omega_-");
	
	unitCase(delta_plusplus.C, 0, "C " + delta_plusplus + " delta++");
	unitCase(delta_plusplus.qx, 2, "qx " + delta_plusplus + " delta++");
	unitCase(delta_plusplus.q, 2, "q " + delta_plusplus + " delta++");
	unitCase(MainFunctions.massEquation(delta_plusplus, 2, 1, 9, 4), 1232.91663788, 1232, "Mass Baryon delta_++");
	
	unitCase(delta_plus.C, 0, "C " + delta_plus + " delta+");
	unitCase(delta_plus.qx, 1, "qx " + delta_plus + " delta+");
	unitCase(delta_plus.q, 1, "q " + delta_plus + " delta+");
	unitCase(MainFunctions.massEquation(delta_plus, 2, -1, -1, -6), 1234.60981181, 1232, "Mass Baryon delta_+");
	
	unitCase(delta_minus.C, 0, "C " + delta_minus + " delta-");
	unitCase(delta_minus.qx, -1, "qx " + delta_minus + " delta-");
	unitCase(delta_minus.q, 1, "q " + delta_minus + " delta-");
	unitCase(MainFunctions.massEquation(delta_minus, 2, -1, -16, -15), 1237.06132359, 1232, "Mass Baryon delta_-");
	
	unitCase(delta_zero.C, 0, "C " + delta_zero + " delta0");
	unitCase(delta_zero.qx, 0, "qx " + delta_zero + " delta0");
	unitCase(delta_zero.q, 0, "q " + delta_zero + " delta0");
	unitCase(MainFunctions.massEquation(delta_zero, 2, -1, -10, 2), 1229.99529979, 1232, "Mass Baryon delta_0");*/
    }

    /*
     * If values differ by more then 6 figures they are reported as 
     * incorrect and the result value, tabel value and difference is 
     * displayed. If the case is correct 'GOOD' is displayed together
     * with the result value.
     */
    public static void unitCase(double result, double table, String equation) {

	double difference = Math.abs(result - table);

	if(difference < limit) {
	    System.out.println();
	    System.out.println("=====> "+equation+" GOOD");
	    System.out.println("result: " + result);
	    System.out.println();
	}
	else {
	    System.out.println();
	    System.out.println("=====> "+equation+" INCORRECT!!!");
	    System.out.println("result: " + result);
	    System.out.println(" table: " + table);
	    System.out.println("  diff: " + difference);
	    System.out.println();	    
	}

    }

    public static void unitCase(double result, double table, double experimental, String equation) {

	double difference = Math.abs(result - table);
	double diffHeimGroup = Math.abs(table - experimental);

	if(difference < limit) {
	    System.out.println();
	    System.out.println("=====> "+equation+" GOOD (TABLE)");
	    System.out.println("result: " + result);
	    System.out.println();
	}
	else {
	    System.out.println();
	    System.out.println("=====> "+equation+" INCORRECT (TABLE)!!!");
	    System.out.println("  result: " + result);
	    System.out.println("   table: " + table);
	    System.out.println("    diff: " + difference);
	    System.out.println("(HG)diff: " + diffHeimGroup);
	    System.out.println();	    
	}
    }

}
