
// Version b0.03

import java.math.BigInteger;

// Extended math library with... Factorial, Combination, Root
public class MathL {

    /*
     * NOTE: if BigInteger is not used in the below two functions they will overflow for 
     * 20! which will result in garbage values.
     */
    public static BigInteger factorial(int r) {
	
	BigInteger n = BigInteger.ONE;
	for (int i=1; i<=r; i++) {
	    n = n.multiply(BigInteger.valueOf(i));
	}
	
	return n;
    }
    
    public static int comb(int n, int r) {
	
	return (factorial(n).divide(factorial(r).multiply(factorial(n-r)))).intValue();
    }

    public static double root(double a, double b) {

	return Math.pow(a, (1.0/b));
    }

}
